#include <windows.h>

HINSTANCE g_hInstance;
HWND g_hwMain;

/* DIBpϐ */
BITMAPINFO g_biDIB;
LPDWORD g_lppxDIB;

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow) {

	MSG  msg;
	WNDCLASS wndclass;

	g_hInstance = hInstance;

	/* DIBpBITMAPINFONA */
	ZeroMemory(&g_biDIB, sizeof(g_biDIB));

	/* DIBpBITMAPINFOݒ */
	g_biDIB.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	g_biDIB.bmiHeader.biWidth = 256;
	g_biDIB.bmiHeader.biHeight = 256;
	g_biDIB.bmiHeader.biPlanes = 1;
	g_biDIB.bmiHeader.biBitCount = 32;
	g_biDIB.bmiHeader.biCompression = BI_RGB;

	/* DIBpsNZm */
	g_lppxDIB = (LPDWORD)HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, 256 * 256 * 4);

	/* (16, 31)ɐԂ_i0x00ff0000jł */
	g_lppxDIB[16 + 31 * 256] = 0x00ff0000;

	/* (16, 32)ɐԂ_i0x00ff0000jł */
	g_lppxDIB[16 + 32 * 256] = 0x00ff0000;

	/* EChENXݒ */
	wndclass.style         = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc   = WndProc;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = hInstance;
	wndclass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
	wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = "DIBFIRST";

	RegisterClass(&wndclass);

	/* EChE쐬 */
	g_hwMain = CreateWindow("DIBFIRST", "DIB̍쐬",
	          WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
	          CW_USEDEFAULT, CW_USEDEFAULT,
			  320, 320, NULL, NULL, hInstance, NULL);

	/* EChE\ */
	ShowWindow(g_hwMain, iCmdShow);
	UpdateWindow(g_hwMain);

	/* C[v */
	do {

		/* bZ[W */
		if (GetMessage(&msg,NULL,0,0) == 0) {
			break;
		} else {

			TranslateMessage(&msg);
			DispatchMessage(&msg);

		}

	} while (TRUE);

	/* DIBpsNZ */
	HeapFree(GetProcessHeap(), 0, g_lppxDIB);

	return (int)msg.wParam;

}

/* EChEvV[W[ */
LRESULT CALLBACK WndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam) {

	HDC hdc;
	PAINTSTRUCT ps;

	switch (iMsg) {

	case WM_PAINT: /* `揈 */

		hdc = BeginPaint(hwnd, &ps);

		/* DIB` */
		StretchDIBits(hdc, 0, 0, 256, 256,
	              0, 0, 256, 256, g_lppxDIB,
	              &g_biDIB, DIB_RGB_COLORS, SRCCOPY);

		EndPaint(hwnd, &ps);

		return 0;

	case WM_DESTROY: /* I */

		PostQuitMessage(0);

		return 0;

	}

	return DefWindowProc (hwnd, iMsg, wParam, lParam) ;

}
