#include<windows.h>
#include<string.h>


typedef struct PaintEvent *LpPaintEvent;

struct PaintEvent
{
  HDC hdc;
  PAINTSTRUCT ps;
};



class Frame
{
private:
  
  DWORD id;
  WNDCLASS winc;
  HWND hwnd;
  MSG msg;
  
public :
  
  DWORD getID();
  void setID(DWORD);
  Frame();
  void show();
  HWND getHwnd();
  int EventRoop();
  int onClick();
  void onInit();
  void onPaint(PaintEvent);
  ~Frame();
  
};



typedef Frame *lpFrame;

static int database_num = 0;
static lpFrame database[100];


static void add(lpFrame obj)
{
  if(database_num <= 100)
    {
      database[database_num] = obj;
      database_num++;
    }
}

static lpFrame search(HWND hwnd)
{
  int i;
  for(i = 0; i< database_num;i++)
    {
      if(hwnd == database[i]->getHwnd())
        {
          return database[i];
        }
    }

  return NULL;
}

LRESULT CALLBACK WndProc(HWND hwnd,UINT msg,WPARAM w,LPARAM l)
{
  
  lpFrame fra;
    
    if((fra=search(hwnd)) != NULL)
      {
        if(msg == WM_LBUTTONUP)
          {
            fra->onClick();
            return 0;
          }
        else if(msg == WM_CREATE)
          {
                  MessageBox(NULL,"","sdf",MB_OK);
            fra->onInit();
          }
        else if(msg == WM_PAINT)
          {
            PaintEvent e;
            e.hdc = BeginPaint(hwnd,&e.ps);
            fra->onPaint(e);
            EndPaint(hwnd,&e.ps);
            return 0;
          }
      }
 
  return DefWindowProc(hwnd,msg,w,l);
       
}


